*******************************************************************************
* demo.prg
*
* demonstration of CB_GPR1x.lib
*
* (c) 1994 Christopher Blencowe
* Clipper 5.x / CB_GPR1.l5x
*********************************************************************
 
*******************************************************************************
* Used functions: gpr_init(), gpr_deinit() , gpr_text(), gpr_width()
* Used variables: gpr_linesa[]
*******************************************************************************
 
*******************************************************************************
* You may adjust the DEFAULTNAME to the compiled font file names
 
* only one font possible in shareware version
#define DEFAULTFONT 1
* give full or relative path\file name without extension
#define DEFAULTNAME1 "..\helv40p\lj150\helv40p"
#define DEFAULTNAME2 "..\helv40p\ibm180\helv40p"
#define DEFAULTNAME3 "..\helv40p\eps180\helv40p"
 
#define NUMBERNAME1 "..\aria168\lj150\aria168"
#define NUMBERNAME2 "..\aria168\ibm180\aria168"
#define NUMBERNAME3 "..\aria168\eps180\aria168"
 
* really copy spoolfile to printer
#undef DOPRINT
*******************************************************************************
* To avoid the CHR(26) problem change the line below if you have
* a low level print function as in CA-TOOLS III called PRINTSEND()
#undef HAS_PRINTSEND
 
#ifdef HAS_PRINTSEND
#command ?? <x> => printsend(<x>,"LPT1")
#endif
 
*******************************************************************************
* No more changes neccesary below
 
PRIVATE line,nWidth
 
nWidth=0
CLEAR
type:="GQ "
demo:=1
@0,0 SAY "Which TYPE of printer do you have (EPS/IBM/LJ/DJ/GQ): " GET type PICTURE "@!" VALID ("$"+type+"$")$("$EPS$IBM$LJ $DJ $GQ $")
@2,0 SAY "Which demonstration do you like (1-7): " GET demo PICTURE "9" VALID demo>=1 .AND. demo<=7
READ
@4,0 SAY "Demonstration #" + ALLTRIM(STR(demo)) + " in progress ..."
 
DO CASE
CASE ("$"+type+"$")$("$LJ $DJ $GQ $") .AND. demo<=6
   name=DEFAULTNAME1
CASE ("$"+type+"$")$("$LJ $DJ $GQ $") .AND. demo>6
   name=NUMBERNAME1
CASE type=="IBM" .AND. demo<=6
   name=DEFAULTNAME2
CASE type=="IBM" .AND. demo>6
   name=NUMBERNAME2
CASE type=="EPS" .AND. demo<=6
   name=DEFAULTNAME3
CASE type=="EPS" .AND. demo>6
   name=NUMBERNAME3
ENDCASE
 
IF FILE(name+".mem") .AND. FILE(name+".arr")
   file="file"
   SET CONSOLE OFF
   SET MARGIN TO 5
   SET PRINTER TO (file)
   SET PRINT ON
    
   ? gpr_version()   && for MARGIN
    
   ? gpr_init(name,type)
    
   DO CASE
   CASE demo=1
      for line=1 to gpr_linesa[DEFAULTFONT]
         ?? ">>>"+gpr_text(DEFAULTFONT,line,"ABCDEFGHIJKLMNOPQRSTUVWXYZ",@nWidth)+"<<<" + STR(nWidth,4,2)+"inch"
         ?
      next line
       
      for line=1 to gpr_linesa[DEFAULTFONT]
         ?? ">>>"+gpr_text(DEFAULTFONT,line,"abcdefghijklmnopqrstuvwxyz",@nWidth)+"<<<" + STR(nWidth,4,2)+"inch"
         ?
      next line
       
      for line=1 to gpr_linesa[DEFAULTFONT]
         ?? ">>>"+gpr_text(DEFAULTFONT,line,"+-.,;:<>",@nWidth)+"<<<" + STR(nWidth,4,2)+"inch"
         ?
      next line
       
   CASE demo=2
      for line=1 to gpr_linesa[DEFAULTFONT]
         ?? gpr_text(DEFAULTFONT,line,"The quick brown",@nWidth,0.5)+"<"
         ?
      next line
       
      for line=1 to gpr_linesa[DEFAULTFONT]
         ?? gpr_text(DEFAULTFONT,line,"fox jumps over",@nWidth,0.5)+"<"
         ?
      next line
       
      for line=1 to gpr_linesa[DEFAULTFONT]
         ?? gpr_text(DEFAULTFONT,line,"the lazy dog.",@nWidth,0.5)+"<"
         ?
      next line
       
   CASE demo=3
      ? "Width of 20x A" , gpr_width(DEFAULTFONT,REPLICATE("A",20))
      ? "Width of 20x " , gpr_width(DEFAULTFONT,REPLICATE("a",20))
      ? "Width of 20x  " , gpr_width(DEFAULTFONT,REPLICATE(" ",20))  && usually 1/2 the size of the capital 'W'
      ? "Width of 20x " , gpr_width(DEFAULTFONT,REPLICATE("",20))  && usually not implemented
       
   CASE demo=4
      for line=1 to gpr_linesa[DEFAULTFONT]
         ?? ">>>"+gpr_text(DEFAULTFONT,line,"{}",@nWidth,1)+"<<<" + STR(nWidth,4,2)+"inch"
         ?
      next line
       
   CASE demo=5
      for line=1 to gpr_linesa[DEFAULTFONT]
         ?? ">>>"+gpr_text(DEFAULTFONT,line,"0123456789+-*/=",@nWidth,1)+"<<<" + STR(nWidth,4,2)+"inch"
         ?
      next line
       
   CASE demo=6
      for line=1 to gpr_linesa[DEFAULTFONT]
         ?? gpr_text(DEFAULTFONT,line,"Field1",@nWidth,0.5)
         ?? gpr_text(DEFAULTFONT,line,"Field2",@nWidth,1)
         ?? gpr_text(DEFAULTFONT,line,"Field3",@nWidth,0.5)
         ?
      next line
       
      for line=1 to gpr_linesa[DEFAULTFONT]
         ?? gpr_text(DEFAULTFONT,line,"123.23",@nWidth,0.5)
         ?? gpr_text(DEFAULTFONT,line,"20",@nWidth,1)
         ?? gpr_text(DEFAULTFONT,line,"99.99",@nWidth,0.5)
         ?
      next line
       
   CASE demo=7
      for line=1 to gpr_linesa[DEFAULTFONT]
         ?? gpr_text(DEFAULTFONT,line,"01234",@nWidth)
         ?
      next line
       
      for line=1 to gpr_linesa[DEFAULTFONT]
         ?? gpr_text(DEFAULTFONT,line,"56789",@nWidth)
         ?
      next line
       
   ENDCASE
    
   ?
   ?
   ?
   ?
    
   IF GPR_PTYP="LJ" .OR. GPR_PTYP="GQ"
      ?? gpr_deinit()
      EJECT
   ELSE
      ?? gpr_deinit()
   ENDIF
    
   SET PRINT OFF
   SET PRINTER TO
   #ifdef DOPRINT
   IF FILE(file + ".prn")
      RUN ("copy "+ file + ".prn PRN /b >NUL")
   ENDIF
   #endif
    
ELSE
   ?
   ? "Sorry, font files not found, have you precompiled them ?"
ENDIF
 
?
 
RETURN
 
*******************************************************************************
* that's all
*******************************************************************************
