*******************************************************************************
* demo.prg
*
* demonstration of CB_GPR1x.lib
*
* (c) 1994 Christopher Blencowe
* Clipper 5.x / CB_GPR1.x / barcode.lib
*********************************************************************
 
*******************************************************************************
* Used functions: gpr_init(), gpr_deinit() , gpr_text(), gpr_width()
* Used variables: gpr_linesa[]
*******************************************************************************
 
*******************************************************************************
* only one font possible in shareware version
#define DEFAULTFONT 1
 
* really copy spoolfile to printer
#undef DOPRINT
*******************************************************************************
* To avoid the CHR(26) problem change the line below if you have
* a low level print function as in CA-TOOLS III called PRINTSEND()
#undef HAS_PRINTSEND
 
#ifdef HAS_PRINTSEND
#command ?? <x> => printsend(<x>,"LPT1")
#endif
 
*******************************************************************************
* No more changes neccesary below
 
PRIVATE line,nWidth
 
nWidth=0
CLEAR
type:="GQ "
demo:=PADR("ABCDEF",15)
@0,0 SAY "Which TYPE of printer do you have (EPS/IBM/LJ/DJ/GQ): " GET type PICTURE "@!" VALID ("$"+type+"$")$("$EPS$IBM$LJ $DJ $GQ $")
@1,0 SAY "Enter a Text to be printed                            " GET demo PICTURE "@!"
READ
 
DO CASE
CASE type+" "$"IBM EPS "
   pres=180
   @ 3,0 say "60/180dpi                                             " get pres PICTURE "999" VALID pres=60 .OR. pres=180
CASE type+" "$"LJ  DJ GQ  "
   pres=150
   @ 3,0 say "75/150/300dpi                                         " get pres PICTURE "999" VALID pres=75 .OR. pres=150 .OR. pres=300
ENDCASE
READ
 
name="..\BC96P\"+ALLTRIM(IIF(type="DJ " .OR. type="GQ","LJ ",type))+ALLTRIM(STR(pres))+"\bc96p"
 
@5,0 SAY gpr_version()
@6,0 SAY "Demonstration in progress ..."
@7,0 SAY "Text: " + ALLTRIM(demo)
@8,0 SAY "Code: " + bc_code39(ALLTRIM(demo))
 
IF FILE(name+".mem") .AND. FILE(name+".arr")
   file="file"
   SET CONSOLE OFF
   SET DATE GERMAN
   SET MARGIN TO 5
   SET PRINTER TO (file)
   SET PRINT ON
    
   ? gpr_version()
   ? DTOC(DATE()) + " - " + TIME()
   ? ALLTRIM(demo)           && for MARGIN
    
   ?? gpr_init(name,type)         && changes verical line spacing
    
   for line=1 to gpr_linesa[DEFAULTFONT]
      ? gpr_text(DEFAULTFONT,line,bc_code39(ALLTRIM(demo)),@nWidth)
   next line
    
   ?? gpr_deinit()           && changes verical line spacing
    
   ?
   ?
    
   IF GPR_PTYP="LJ" .OR. GPR_PTYP="GQ"
      EJECT
   ENDIF
    
   SET PRINT OFF
   SET PRINTER TO
   #ifdef DOPRINT
   IF FILE(file + ".prn")
      RUN ("copy "+ file + ".prn PRN /b >NUL")
   ENDIF
   #endif
    
ELSE
   ?
   ? "Sorry, font files not found, have you precompiled them ?"
   ?
ENDIF
 
RETURN
 
*******************************************************************************
* that's all
*******************************************************************************
